function [buf,SampleRate]=udpadc(skt,adcpins,SampleRate,SamplesToGet)
%function [buff,SampleRate]=udpadc(skt,adcpins,SampleRate,SamplesToGet)
% Functon showing how to use PIC board as adc
% SampleRate=1000;
% SamplesToGet=1000;
% select pins to be used for ADC - ANx 
% eg 9 and 10  adcpins=[9 10] or adcpins=[0 1 2 3 4 9 10 ];
% adcpins=[0 1 2 3 4 9 10];
% example call [buf,SampleRate]=udpadc1(skt,[0 1 2 3 4 9 10],1000,10000);
%
% if SamplesToGet*Number of channels (i.e. pins) is les than buffersize
% then functon will do a single shot capture 
% - with single channel sample rate to 200kHz
% otherwise wil use software tail chasing - max rate depends on PC 
% - orange pi pc gets around 12kHz single channel
% if called with 3 arguments then it will set the pic going 
% - but catch no samples and exit leaving PIC going
% Currently ok for 
%dspic33ep256gp502
%dspic33fj128gp502
%dspic33fj128gp802
%pic24hj128gp502
if (nargin<4)
  SamplesToGet=0;
end  
NumChan=max(size(adcpins));

CPU_Speed=udpget(skt,'CPU_SPEED');
Timer_Divisor=uint16(floor((CPU_Speed/(SampleRate*NumChan))+0.5)-1);
SampleRate=CPU_Speed/((Timer_Divisor+1)*NumChan);

DMA_base_addr=udpget(skt,'DMA_BASE');

[d,DMABUF_ADDR]=udpget(skt,'DMABufferA');
[adcval,ADC_ADDR]=udpget(skt,'ADC1BUF0');
DMABufferSize=max(size(d)); % in words not bytes as type is uint16
DMABufferSize=NumChan*floor(DMABufferSize/NumChan); % whole number of sample frames in a buffer

%Stop All
udpset(skt,'T5CON',0);   % Stop T5 
udpset(skt,'AD1CON1',0); % Stop Adc
udpset(skt,'DMA0CON',0); % Stop DMA  

% AN0 - ANSELA0 AD1PCFGL0
% AN1 - ANSELA1 AD1PCFGL1
% AN2 - ANSELB0 AD1PCFGL2
% AN3 - ANSELB1 AD1PCFGL3
% AN4 - ANSELB2 AD1PCFGL4
% AN5 - ANSLEB3 AD1PCFGL5

if min(size(findname(skt.name,'ANSELA',1:max(size(skt.name)))))>0
  %EP CHIP
  apins=adcpins(find(adcpins<2));
  amask=sum(2.^apins);
  adigpins=udpget(skt,'ANSELA');
  adigpins=bitor(adigpins,amask);
  udpset(skt,'ANSELA',adigpins);
  bpins=adcpins(find(adcpins>=2));
  bmask=sum(2.^(bpins-2));
  bdigpins=udpget(skt,'ANSELB');
  bdigpins=bitor(bdigpins,bmask);
  udpset(skt,'ANSELB',bdigpins);
  udpset(skt,'AD1CSSH',0);
  DMA='DMA0STAL';
else  
  %FJ or HJ CHIP
  mask=(2^16-1)-sum(2.^adcpins); % setting pins =1 gives dig =0 gives analog - see datasheet
  digpins=udpget(skt,'AD1PCFGL');  
  digpins=bitand(digpins,mask);
  udpset(skt,'AD1PCFGL',digpins);
  DMA='DMA0STA';
end  

SingleShot = ((SamplesToGet*NumChan)<=DMABufferSize);
if (SamplesToGet==0) 
  SingleShot=0;
end
% DMA channels 0-5 are unused - we will use 0
if (SingleShot==0)
 udpset(skt,'DMA0CON',bin2dec('0000 0000 0000 0000')); % see DMAxCON in data sheet
else
 udpset(skt,'DMA0CON',bin2dec('0000 0000 0000 0001')); % see DMAxCON in data sheet
end
udpset(skt,'DMA0REQ',bin2dec('0000 0000 0000 1101')); % atach to ADC eocsee DMAxREQ in data sheet
udpset(skt,DMA,DMABUF_ADDR); %Set dma start Address in DMA0STA in data sheet
udpset(skt,'DMA0PAD',ADC_ADDR); %Set ADC adress for dma to read
udpset(skt,'DMA0CNT',DMABufferSize-1); %Number of values to move -1

%Setup Timer 5
udpset(skt,'PR5',Timer_Divisor); %Config for T5 - see datasheet

%Setup ADC
udpset(skt,'AD1CON2',bin2dec('0 0 0 0  0 1 0 0  0 0 0 0  0 0 0 0')+(NumChan-1)*4); %Config for adc - see datasheet
udpset(skt,'AD1CON3',bin2dec('0 0 0 0  0 1 1 1  0 0 0 0  0 1 0 0')); %Config for adc - see datasheet
udpset(skt,'AD1CON4',bin2dec('0 0 0 0  0 0 0 1  0 0 0 0  0 0 0 0')); %Config for adc - see datasheet
udpset(skt,'AD1CSSL',sum(2.^adcpins)); %Config for adc channels to scan - see datasheet

% Set all going
udpset(skt,'DMA0CON',bitor(bin2dec('1 0 0 0  0 0 0 0  0 0 0 0  0 0 0 0'),udpget(skt,'DMA0CON'))); % Set DMA going
udpset(skt,'AD1CON1',bin2dec('1 0 0 1  0 1 0 0  1 0 0 0  0 1 1 1')); % Config for adc using timer 5 - see datasheet
udpset(skt,'T5CON',bin2dec('1 0 0 0  0 0 0 0  0 0 0 0  0 0 0 0')); %Config for T5 - see datasheet


if (SamplesToGet>0)
 if (SingleShot==0)
  %treat DMA as fifo and chase the head
  tail=1;
  buf=[];
  cnt=0;
  while(cnt<(SamplesToGet*NumChan))
   ptr=(udpget(skt,DMA)+DMA_base_addr-DMABUF_ADDR)/2+1;
   if (tail>ptr)
    data=udppeek(skt,DMABUF_ADDR+((tail-1)*2),(DMABufferSize-tail+1)*2);
    buf=[buf data];
    cnt=cnt+DMABufferSize-tail+1;
    tail=1; 
   end 
   if (ptr>tail) 
    data=udppeek(skt,DMABUF_ADDR+((tail-1)*2),(ptr-tail)*2);
    buf=[buf data];
    cnt=cnt+ptr-tail;
    tail=ptr;
   end
  end
  buf=udpgettconv(buf,2,1);
  else
  ptr=0;
  pause(1/SampleRate); %wait at least 1 sample
  while(((udpget(skt,DMA)+DMA_base_addr-DMABUF_ADDR)/2+1)>1)
  end;
  buf=udpget(skt,'DMABufferA'); 
 end 
 %Stop All
 udpset(skt,'T5CON',0);   % Stop T5 
 udpset(skt,'AD1CON1',0); % Stop Adc
 udpset(skt,'DMA0CON',0); % Stop DMA  

 % Top and tail the buffers
 buf=buf(1:(SamplesToGet*NumChan));
 buf=reshape(buf,NumChan,SamplesToGet)';
else
 buf=[];
end